package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters._
sealed trait PlacementStrategyType {
  def unwrap
      : software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType
}
object PlacementStrategyType {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType
  ): zio.aws.eventbridge.model.PlacementStrategyType = value match {
    case software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.RANDOM =>
      val r = random
      r
    case software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.SPREAD =>
      val r = spread
      r
    case software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.BINPACK =>
      val r = binpack
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType =
      software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.UNKNOWN_TO_SDK_VERSION
  }
  case object random extends zio.aws.eventbridge.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType =
      software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.RANDOM
  }
  case object spread extends zio.aws.eventbridge.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType =
      software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.SPREAD
  }
  case object binpack extends zio.aws.eventbridge.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType =
      software.amazon.awssdk.services.eventbridge.model.PlacementStrategyType.BINPACK
  }
}
