package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{Timestamp, AccountId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PartnerEventSourceAccount(
    account: Optional[AccountId] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    expirationTime: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.EventSourceState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PartnerEventSourceAccount = {
    import PartnerEventSourceAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PartnerEventSourceAccount
      .builder()
      .optionallyWith(
        account.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        expirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly =
    zio.aws.eventbridge.model.PartnerEventSourceAccount.wrap(buildAwsValue())
}
object PartnerEventSourceAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PartnerEventSourceAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PartnerEventSourceAccount =
      zio.aws.eventbridge.model.PartnerEventSourceAccount(
        account.map(value => value),
        creationTime.map(value => value),
        expirationTime.map(value => value),
        state.map(value => value)
      )
    def account: Optional[AccountId]
    def creationTime: Optional[Timestamp]
    def expirationTime: Optional[Timestamp]
    def state: Optional[zio.aws.eventbridge.model.EventSourceState]
    def getAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("account", account)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.EventSourceState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PartnerEventSourceAccount
  ) extends zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly {
    override val account: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.eventbridge.model.primitives.AccountId(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val expirationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val state: Optional[zio.aws.eventbridge.model.EventSourceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.EventSourceState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PartnerEventSourceAccount
  ): zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly = new Wrapper(
    impl
  )
}
