package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PartnerEventSource(
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PartnerEventSource = {
    import PartnerEventSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PartnerEventSource
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PartnerEventSource.ReadOnly =
    zio.aws.eventbridge.model.PartnerEventSource.wrap(buildAwsValue())
}
object PartnerEventSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PartnerEventSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PartnerEventSource =
      zio.aws.eventbridge.model
        .PartnerEventSource(arn.map(value => value), name.map(value => value))
    def arn: Optional[String]
    def name: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PartnerEventSource
  ) extends zio.aws.eventbridge.model.PartnerEventSource.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PartnerEventSource
  ): zio.aws.eventbridge.model.PartnerEventSource.ReadOnly = new Wrapper(impl)
}
