package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkConfiguration(
    awsvpcConfiguration: Optional[
      zio.aws.eventbridge.model.AwsVpcConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.NetworkConfiguration
      .builder()
      .optionallyWith(awsvpcConfiguration.map(value => value.buildAwsValue()))(
        _.awsvpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.NetworkConfiguration.ReadOnly =
    zio.aws.eventbridge.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.NetworkConfiguration =
      zio.aws.eventbridge.model.NetworkConfiguration(
        awsvpcConfiguration.map(value => value.asEditable)
      )
    def awsvpcConfiguration
        : Optional[zio.aws.eventbridge.model.AwsVpcConfiguration.ReadOnly]
    def getAwsvpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.AwsVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("awsvpcConfiguration", awsvpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.NetworkConfiguration
  ) extends zio.aws.eventbridge.model.NetworkConfiguration.ReadOnly {
    override val awsvpcConfiguration
        : Optional[zio.aws.eventbridge.model.AwsVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsvpcConfiguration())
        .map(value => zio.aws.eventbridge.model.AwsVpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.NetworkConfiguration
  ): zio.aws.eventbridge.model.NetworkConfiguration.ReadOnly = new Wrapper(impl)
}
