package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTargetsByRuleResponse(
    targets: Optional[Iterable[zio.aws.eventbridge.model.Target]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse = {
    import ListTargetsByRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly =
    zio.aws.eventbridge.model.ListTargetsByRuleResponse.wrap(buildAwsValue())
}
object ListTargetsByRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListTargetsByRuleResponse =
      zio.aws.eventbridge.model.ListTargetsByRuleResponse(
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def targets: Optional[List[zio.aws.eventbridge.model.Target.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse
  ) extends zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly {
    override val targets
        : Optional[List[zio.aws.eventbridge.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Target.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse
  ): zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly = new Wrapper(
    impl
  )
}
