package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  EventBusNameOrArn,
  RuleName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTargetsByRuleRequest(
    rule: RuleName,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest = {
    import ListTargetsByRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest
      .builder()
      .rule(RuleName.unwrap(rule): java.lang.String)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListTargetsByRuleRequest.ReadOnly =
    zio.aws.eventbridge.model.ListTargetsByRuleRequest.wrap(buildAwsValue())
}
object ListTargetsByRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListTargetsByRuleRequest =
      zio.aws.eventbridge.model.ListTargetsByRuleRequest(
        rule,
        eventBusName.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def rule: RuleName
    def eventBusName: Optional[EventBusNameOrArn]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getRule: ZIO[Any, Nothing, RuleName] = ZIO.succeed(rule)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest
  ) extends zio.aws.eventbridge.model.ListTargetsByRuleRequest.ReadOnly {
    override val rule: RuleName =
      zio.aws.eventbridge.model.primitives.RuleName(impl.rule())
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest
  ): zio.aws.eventbridge.model.ListTargetsByRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
