package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRulesResponse(
    rules: Optional[Iterable[zio.aws.eventbridge.model.Rule]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListRulesResponse = {
    import ListRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListRulesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListRulesResponse.ReadOnly =
    zio.aws.eventbridge.model.ListRulesResponse.wrap(buildAwsValue())
}
object ListRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListRulesResponse =
      zio.aws.eventbridge.model.ListRulesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def rules: Optional[List[zio.aws.eventbridge.model.Rule.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRulesResponse
  ) extends zio.aws.eventbridge.model.ListRulesResponse.ReadOnly {
    override val rules
        : Optional[List[zio.aws.eventbridge.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Rule.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRulesResponse
  ): zio.aws.eventbridge.model.ListRulesResponse.ReadOnly = new Wrapper(impl)
}
