package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  EventBusNameOrArn,
  RuleName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRulesRequest(
    namePrefix: Optional[RuleName] = Optional.Absent,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListRulesRequest = {
    import ListRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListRulesRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListRulesRequest.ReadOnly =
    zio.aws.eventbridge.model.ListRulesRequest.wrap(buildAwsValue())
}
object ListRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListRulesRequest =
      zio.aws.eventbridge.model.ListRulesRequest(
        namePrefix.map(value => value),
        eventBusName.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: Optional[RuleName]
    def eventBusName: Optional[EventBusNameOrArn]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRulesRequest
  ) extends zio.aws.eventbridge.model.ListRulesRequest.ReadOnly {
    override val namePrefix: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.eventbridge.model.primitives.RuleName(value))
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRulesRequest
  ): zio.aws.eventbridge.model.ListRulesRequest.ReadOnly = new Wrapper(impl)
}
