package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPartnerEventSourcesResponse(
    partnerEventSources: Optional[
      Iterable[zio.aws.eventbridge.model.PartnerEventSource]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse = {
    import ListPartnerEventSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse
      .builder()
      .optionallyWith(
        partnerEventSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partnerEventSources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly =
    zio.aws.eventbridge.model.ListPartnerEventSourcesResponse
      .wrap(buildAwsValue())
}
object ListPartnerEventSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListPartnerEventSourcesResponse =
      zio.aws.eventbridge.model.ListPartnerEventSourcesResponse(
        partnerEventSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def partnerEventSources
        : Optional[List[zio.aws.eventbridge.model.PartnerEventSource.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPartnerEventSources: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PartnerEventSource.ReadOnly
    ]] = AwsError.unwrapOptionField("partnerEventSources", partnerEventSources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse
  ) extends zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly {
    override val partnerEventSources: Optional[
      List[zio.aws.eventbridge.model.PartnerEventSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerEventSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.PartnerEventSource.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse
  ): zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly =
    new Wrapper(impl)
}
