package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPartnerEventSourceAccountsResponse(
    partnerEventSourceAccounts: Optional[
      Iterable[zio.aws.eventbridge.model.PartnerEventSourceAccount]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse = {
    import ListPartnerEventSourceAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse
      .builder()
      .optionallyWith(
        partnerEventSourceAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partnerEventSourceAccounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly =
    zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse
      .wrap(buildAwsValue())
}
object ListPartnerEventSourceAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse =
      zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse(
        partnerEventSourceAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def partnerEventSourceAccounts: Optional[
      List[zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPartnerEventSourceAccounts: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "partnerEventSourceAccounts",
      partnerEventSourceAccounts
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse
  ) extends zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly {
    override val partnerEventSourceAccounts: Optional[
      List[zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerEventSourceAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.PartnerEventSourceAccount.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse
  ): zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
