package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEventBusesResponse(
    eventBuses: Optional[Iterable[zio.aws.eventbridge.model.EventBus]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse = {
    import ListEventBusesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse
      .builder()
      .optionallyWith(
        eventBuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventBuses)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly =
    zio.aws.eventbridge.model.ListEventBusesResponse.wrap(buildAwsValue())
}
object ListEventBusesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListEventBusesResponse =
      zio.aws.eventbridge.model.ListEventBusesResponse(
        eventBuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventBuses: Optional[List[zio.aws.eventbridge.model.EventBus.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEventBuses: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.EventBus.ReadOnly
    ]] = AwsError.unwrapOptionField("eventBuses", eventBuses)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse
  ) extends zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly {
    override val eventBuses
        : Optional[List[zio.aws.eventbridge.model.EventBus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.EventBus.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse
  ): zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly = new Wrapper(
    impl
  )
}
