package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListConnectionsResponse(
    connections: Optional[Iterable[zio.aws.eventbridge.model.Connection]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListConnectionsResponse = {
    import ListConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly =
    zio.aws.eventbridge.model.ListConnectionsResponse.wrap(buildAwsValue())
}
object ListConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListConnectionsResponse =
      zio.aws.eventbridge.model.ListConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connections
        : Optional[List[zio.aws.eventbridge.model.Connection.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListConnectionsResponse
  ) extends zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly {
    override val connections
        : Optional[List[zio.aws.eventbridge.model.Connection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Connection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListConnectionsResponse
  ): zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
