package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  ConnectionName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListConnectionsRequest(
    namePrefix: Optional[ConnectionName] = Optional.Absent,
    connectionState: Optional[zio.aws.eventbridge.model.ConnectionState] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest = {
    import ListConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value => ConnectionName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListConnectionsRequest.ReadOnly =
    zio.aws.eventbridge.model.ListConnectionsRequest.wrap(buildAwsValue())
}
object ListConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListConnectionsRequest =
      zio.aws.eventbridge.model.ListConnectionsRequest(
        namePrefix.map(value => value),
        connectionState.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: Optional[ConnectionName]
    def connectionState: Optional[zio.aws.eventbridge.model.ConnectionState]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.ConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest
  ) extends zio.aws.eventbridge.model.ListConnectionsRequest.ReadOnly {
    override val namePrefix: Optional[ConnectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionName(value))
    override val connectionState
        : Optional[zio.aws.eventbridge.model.ConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value => zio.aws.eventbridge.model.ConnectionState.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest
  ): zio.aws.eventbridge.model.ListConnectionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
