package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  Arn,
  ArchiveName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListArchivesRequest(
    namePrefix: Optional[ArchiveName] = Optional.Absent,
    eventSourceArn: Optional[Arn] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ArchiveState] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest = {
    import ListArchivesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value => ArchiveName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListArchivesRequest.ReadOnly =
    zio.aws.eventbridge.model.ListArchivesRequest.wrap(buildAwsValue())
}
object ListArchivesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListArchivesRequest =
      zio.aws.eventbridge.model.ListArchivesRequest(
        namePrefix.map(value => value),
        eventSourceArn.map(value => value),
        state.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: Optional[ArchiveName]
    def eventSourceArn: Optional[Arn]
    def state: Optional[zio.aws.eventbridge.model.ArchiveState]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, ArchiveName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ArchiveState] =
      AwsError.unwrapOptionField("state", state)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest
  ) extends zio.aws.eventbridge.model.ListArchivesRequest.ReadOnly {
    override val namePrefix: Optional[ArchiveName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.eventbridge.model.primitives.ArchiveName(value))
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.eventbridge.model.primitives.Arn(value))
    override val state: Optional[zio.aws.eventbridge.model.ArchiveState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ArchiveState.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest
  ): zio.aws.eventbridge.model.ListArchivesRequest.ReadOnly = new Wrapper(impl)
}
