package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListApiDestinationsResponse(
    apiDestinations: Optional[
      Iterable[zio.aws.eventbridge.model.ApiDestination]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsResponse = {
    import ListApiDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsResponse
      .builder()
      .optionallyWith(
        apiDestinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apiDestinations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly =
    zio.aws.eventbridge.model.ListApiDestinationsResponse.wrap(buildAwsValue())
}
object ListApiDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListApiDestinationsResponse =
      zio.aws.eventbridge.model.ListApiDestinationsResponse(
        apiDestinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def apiDestinations
        : Optional[List[zio.aws.eventbridge.model.ApiDestination.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getApiDestinations: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.ApiDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("apiDestinations", apiDestinations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsResponse
  ) extends zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly {
    override val apiDestinations
        : Optional[List[zio.aws.eventbridge.model.ApiDestination.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.ApiDestination.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsResponse
  ): zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
