package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  TransformerInput,
  TargetInputPath,
  InputTransformerPathKey
}
import scala.jdk.CollectionConverters._
final case class InputTransformer(
    inputPathsMap: Optional[Map[InputTransformerPathKey, TargetInputPath]] =
      Optional.Absent,
    inputTemplate: TransformerInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.InputTransformer = {
    import InputTransformer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.InputTransformer
      .builder()
      .optionallyWith(
        inputPathsMap.map(value =>
          value
            .map({ case (key, value) =>
              (InputTransformerPathKey
                .unwrap(key): java.lang.String) -> (TargetInputPath
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.inputPathsMap)
      .inputTemplate(TransformerInput.unwrap(inputTemplate): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.InputTransformer.ReadOnly =
    zio.aws.eventbridge.model.InputTransformer.wrap(buildAwsValue())
}
object InputTransformer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.InputTransformer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.InputTransformer =
      zio.aws.eventbridge.model
        .InputTransformer(inputPathsMap.map(value => value), inputTemplate)
    def inputPathsMap: Optional[Map[InputTransformerPathKey, TargetInputPath]]
    def inputTemplate: TransformerInput
    def getInputPathsMap
        : ZIO[Any, AwsError, Map[InputTransformerPathKey, TargetInputPath]] =
      AwsError.unwrapOptionField("inputPathsMap", inputPathsMap)
    def getInputTemplate: ZIO[Any, Nothing, TransformerInput] =
      ZIO.succeed(inputTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.InputTransformer
  ) extends zio.aws.eventbridge.model.InputTransformer.ReadOnly {
    override val inputPathsMap
        : Optional[Map[InputTransformerPathKey, TargetInputPath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputPathsMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eventbridge.model.primitives.InputTransformerPathKey(
                key
              ) -> zio.aws.eventbridge.model.primitives.TargetInputPath(value)
            })
            .toMap
        )
    override val inputTemplate: TransformerInput =
      zio.aws.eventbridge.model.primitives
        .TransformerInput(impl.inputTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.InputTransformer
  ): zio.aws.eventbridge.model.InputTransformer.ReadOnly = new Wrapper(impl)
}
