package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  QueryStringKey,
  QueryStringValue,
  HeaderKey,
  PathParameter,
  HeaderValue
}
import scala.jdk.CollectionConverters._
final case class HttpParameters(
    pathParameterValues: Optional[Iterable[PathParameter]] = Optional.Absent,
    headerParameters: Optional[Map[HeaderKey, HeaderValue]] = Optional.Absent,
    queryStringParameters: Optional[Map[QueryStringKey, QueryStringValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.HttpParameters = {
    import HttpParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.HttpParameters
      .builder()
      .optionallyWith(
        pathParameterValues.map(value =>
          value.map { item =>
            PathParameter.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pathParameterValues)
      .optionallyWith(
        headerParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HeaderKey.unwrap(key): java.lang.String) -> (HeaderValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.headerParameters)
      .optionallyWith(
        queryStringParameters.map(value =>
          value
            .map({ case (key, value) =>
              (QueryStringKey
                .unwrap(key): java.lang.String) -> (QueryStringValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.queryStringParameters)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.HttpParameters.ReadOnly =
    zio.aws.eventbridge.model.HttpParameters.wrap(buildAwsValue())
}
object HttpParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.HttpParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.HttpParameters =
      zio.aws.eventbridge.model.HttpParameters(
        pathParameterValues.map(value => value),
        headerParameters.map(value => value),
        queryStringParameters.map(value => value)
      )
    def pathParameterValues: Optional[List[PathParameter]]
    def headerParameters: Optional[Map[HeaderKey, HeaderValue]]
    def queryStringParameters: Optional[Map[QueryStringKey, QueryStringValue]]
    def getPathParameterValues: ZIO[Any, AwsError, List[PathParameter]] =
      AwsError.unwrapOptionField("pathParameterValues", pathParameterValues)
    def getHeaderParameters: ZIO[Any, AwsError, Map[HeaderKey, HeaderValue]] =
      AwsError.unwrapOptionField("headerParameters", headerParameters)
    def getQueryStringParameters
        : ZIO[Any, AwsError, Map[QueryStringKey, QueryStringValue]] =
      AwsError.unwrapOptionField("queryStringParameters", queryStringParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.HttpParameters
  ) extends zio.aws.eventbridge.model.HttpParameters.ReadOnly {
    override val pathParameterValues: Optional[List[PathParameter]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathParameterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.primitives.PathParameter(item)
          }.toList
        )
    override val headerParameters: Optional[Map[HeaderKey, HeaderValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headerParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eventbridge.model.primitives.HeaderKey(
                key
              ) -> zio.aws.eventbridge.model.primitives.HeaderValue(value)
            })
            .toMap
        )
    override val queryStringParameters
        : Optional[Map[QueryStringKey, QueryStringValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStringParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eventbridge.model.primitives.QueryStringKey(
                key
              ) -> zio.aws.eventbridge.model.primitives.QueryStringValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.HttpParameters
  ): zio.aws.eventbridge.model.HttpParameters.ReadOnly = new Wrapper(impl)
}
