package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters._
sealed trait EndpointState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.EndpointState
}
object EndpointState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.EndpointState
  ): zio.aws.eventbridge.model.EndpointState = value match {
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.eventbridge.model.EndpointState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.ACTIVE
  }
  case object CREATING extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.CREATING
  }
  case object UPDATING extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.UPDATING
  }
  case object DELETING extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.DELETING
  }
  case object CREATE_FAILED extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.UPDATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.eventbridge.model.EndpointState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EndpointState =
      software.amazon.awssdk.services.eventbridge.model.EndpointState.DELETE_FAILED
  }
}
