package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.NonPartnerEventBusArn
import scala.jdk.CollectionConverters._
final case class EndpointEventBus(eventBusArn: NonPartnerEventBusArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.EndpointEventBus = {
    import EndpointEventBus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.EndpointEventBus
      .builder()
      .eventBusArn(NonPartnerEventBusArn.unwrap(eventBusArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.EndpointEventBus.ReadOnly =
    zio.aws.eventbridge.model.EndpointEventBus.wrap(buildAwsValue())
}
object EndpointEventBus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.EndpointEventBus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.EndpointEventBus =
      zio.aws.eventbridge.model.EndpointEventBus(eventBusArn)
    def eventBusArn: NonPartnerEventBusArn
    def getEventBusArn: ZIO[Any, Nothing, NonPartnerEventBusArn] =
      ZIO.succeed(eventBusArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.EndpointEventBus
  ) extends zio.aws.eventbridge.model.EndpointEventBus.ReadOnly {
    override val eventBusArn: NonPartnerEventBusArn =
      zio.aws.eventbridge.model.primitives
        .NonPartnerEventBusArn(impl.eventBusArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.EndpointEventBus
  ): zio.aws.eventbridge.model.EndpointEventBus.ReadOnly = new Wrapper(impl)
}
