package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{ReferenceId, LimitMin1, Arn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EcsParameters(
    taskDefinitionArn: Arn,
    taskCount: Optional[LimitMin1] = Optional.Absent,
    launchType: Optional[zio.aws.eventbridge.model.LaunchType] =
      Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.eventbridge.model.NetworkConfiguration
    ] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    group: Optional[String] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.eventbridge.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    enableECSManagedTags: Optional[Boolean] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.eventbridge.model.PlacementConstraint]
    ] = Optional.Absent,
    placementStrategy: Optional[
      Iterable[zio.aws.eventbridge.model.PlacementStrategy]
    ] = Optional.Absent,
    propagateTags: Optional[zio.aws.eventbridge.model.PropagateTags] =
      Optional.Absent,
    referenceId: Optional[ReferenceId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.eventbridge.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.EcsParameters = {
    import EcsParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.EcsParameters
      .builder()
      .taskDefinitionArn(Arn.unwrap(taskDefinitionArn): java.lang.String)
      .optionallyWith(taskCount.map(value => LimitMin1.unwrap(value): Integer))(
        _.taskCount
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        referenceId.map(value => ReferenceId.unwrap(value): java.lang.String)
      )(_.referenceId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.EcsParameters.ReadOnly =
    zio.aws.eventbridge.model.EcsParameters.wrap(buildAwsValue())
}
object EcsParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.EcsParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.EcsParameters =
      zio.aws.eventbridge.model.EcsParameters(
        taskDefinitionArn,
        taskCount.map(value => value),
        launchType.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        platformVersion.map(value => value),
        group.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableECSManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        propagateTags.map(value => value),
        referenceId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskDefinitionArn: Arn
    def taskCount: Optional[LimitMin1]
    def launchType: Optional[zio.aws.eventbridge.model.LaunchType]
    def networkConfiguration
        : Optional[zio.aws.eventbridge.model.NetworkConfiguration.ReadOnly]
    def platformVersion: Optional[String]
    def group: Optional[String]
    def capacityProviderStrategy: Optional[
      List[zio.aws.eventbridge.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def enableECSManagedTags: Optional[Boolean]
    def enableExecuteCommand: Optional[Boolean]
    def placementConstraints
        : Optional[List[zio.aws.eventbridge.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Optional[List[zio.aws.eventbridge.model.PlacementStrategy.ReadOnly]]
    def propagateTags: Optional[zio.aws.eventbridge.model.PropagateTags]
    def referenceId: Optional[ReferenceId]
    def tags: Optional[List[zio.aws.eventbridge.model.Tag.ReadOnly]]
    def getTaskDefinitionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(taskDefinitionArn)
    def getTaskCount: ZIO[Any, AwsError, LimitMin1] =
      AwsError.unwrapOptionField("taskCount", taskCount)
    def getLaunchType
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getPropagateTags
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getReferenceId: ZIO[Any, AwsError, ReferenceId] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.EcsParameters
  ) extends zio.aws.eventbridge.model.EcsParameters.ReadOnly {
    override val taskDefinitionArn: Arn =
      zio.aws.eventbridge.model.primitives.Arn(impl.taskDefinitionArn())
    override val taskCount: Optional[LimitMin1] = zio.aws.core.internal
      .optionalFromNullable(impl.taskCount())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMin1(value))
    override val launchType: Optional[zio.aws.eventbridge.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.eventbridge.model.LaunchType.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.eventbridge.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value =>
          zio.aws.eventbridge.model.NetworkConfiguration.wrap(value)
        )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val group: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => value: String)
    override val capacityProviderStrategy: Optional[
      List[zio.aws.eventbridge.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val enableECSManagedTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableECSManagedTags())
      .map(value => value: Boolean)
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
    override val placementConstraints: Optional[
      List[zio.aws.eventbridge.model.PlacementConstraint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.PlacementConstraint.wrap(item)
        }.toList
      )
    override val placementStrategy
        : Optional[List[zio.aws.eventbridge.model.PlacementStrategy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStrategy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.PlacementStrategy.wrap(item)
          }.toList
        )
    override val propagateTags
        : Optional[zio.aws.eventbridge.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.eventbridge.model.PropagateTags.wrap(value))
    override val referenceId: Optional[ReferenceId] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceId())
      .map(value => zio.aws.eventbridge.model.primitives.ReferenceId(value))
    override val tags: Optional[List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.EcsParameters
  ): zio.aws.eventbridge.model.EcsParameters.ReadOnly = new Wrapper(impl)
}
