package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  RuleArn,
  RoleArn,
  ScheduleExpression,
  EventPattern,
  RuleDescription,
  RuleName,
  ManagedBy,
  EventBusName,
  CreatedBy
}
import scala.jdk.CollectionConverters._
final case class DescribeRuleResponse(
    name: Optional[RuleName] = Optional.Absent,
    arn: Optional[RuleArn] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.RuleState] = Optional.Absent,
    description: Optional[RuleDescription] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    managedBy: Optional[ManagedBy] = Optional.Absent,
    eventBusName: Optional[EventBusName] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse = {
    import DescribeRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse
      .builder()
      .optionallyWith(
        name.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          RuleDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        managedBy.map(value => ManagedBy.unwrap(value): java.lang.String)
      )(_.managedBy)
      .optionallyWith(
        eventBusName.map(value => EventBusName.unwrap(value): java.lang.String)
      )(_.eventBusName)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeRuleResponse.wrap(buildAwsValue())
}
object DescribeRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeRuleResponse =
      zio.aws.eventbridge.model.DescribeRuleResponse(
        name.map(value => value),
        arn.map(value => value),
        eventPattern.map(value => value),
        scheduleExpression.map(value => value),
        state.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        managedBy.map(value => value),
        eventBusName.map(value => value),
        createdBy.map(value => value)
      )
    def name: Optional[RuleName]
    def arn: Optional[RuleArn]
    def eventPattern: Optional[EventPattern]
    def scheduleExpression: Optional[ScheduleExpression]
    def state: Optional[zio.aws.eventbridge.model.RuleState]
    def description: Optional[RuleDescription]
    def roleArn: Optional[RoleArn]
    def managedBy: Optional[ManagedBy]
    def eventBusName: Optional[EventBusName]
    def createdBy: Optional[CreatedBy]
    def getName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.RuleState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, RuleDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getManagedBy: ZIO[Any, AwsError, ManagedBy] =
      AwsError.unwrapOptionField("managedBy", managedBy)
    def getEventBusName: ZIO[Any, AwsError, EventBusName] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse
  ) extends zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly {
    override val name: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.eventbridge.model.primitives.RuleName(value))
    override val arn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.eventbridge.model.primitives.RuleArn(value))
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.eventbridge.model.primitives.EventPattern(value))
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ScheduleExpression(value)
        )
    override val state: Optional[zio.aws.eventbridge.model.RuleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.RuleState.wrap(value))
    override val description: Optional[RuleDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.eventbridge.model.primitives.RuleDescription(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.RoleArn(value))
    override val managedBy: Optional[ManagedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.managedBy())
      .map(value => zio.aws.eventbridge.model.primitives.ManagedBy(value))
    override val eventBusName: Optional[EventBusName] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBusName())
      .map(value => zio.aws.eventbridge.model.primitives.EventBusName(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.eventbridge.model.primitives.CreatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse
  ): zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly = new Wrapper(impl)
}
