package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  ReplayName,
  ReplayStateReason,
  Timestamp,
  ReplayArn,
  Arn,
  ReplayDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeReplayResponse(
    replayName: Optional[ReplayName] = Optional.Absent,
    replayArn: Optional[ReplayArn] = Optional.Absent,
    description: Optional[ReplayDescription] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ReplayState] = Optional.Absent,
    stateReason: Optional[ReplayStateReason] = Optional.Absent,
    eventSourceArn: Optional[Arn] = Optional.Absent,
    destination: Optional[zio.aws.eventbridge.model.ReplayDestination] =
      Optional.Absent,
    eventStartTime: Optional[Timestamp] = Optional.Absent,
    eventEndTime: Optional[Timestamp] = Optional.Absent,
    eventLastReplayedTime: Optional[Timestamp] = Optional.Absent,
    replayStartTime: Optional[Timestamp] = Optional.Absent,
    replayEndTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeReplayResponse = {
    import DescribeReplayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeReplayResponse
      .builder()
      .optionallyWith(
        replayName.map(value => ReplayName.unwrap(value): java.lang.String)
      )(_.replayName)
      .optionallyWith(
        replayArn.map(value => ReplayArn.unwrap(value): java.lang.String)
      )(_.replayArn)
      .optionallyWith(
        description.map(value =>
          ReplayDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          ReplayStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        eventStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventStartTime)
      .optionallyWith(
        eventEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventEndTime)
      .optionallyWith(
        eventLastReplayedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventLastReplayedTime)
      .optionallyWith(
        replayStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.replayStartTime)
      .optionallyWith(
        replayEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.replayEndTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeReplayResponse.wrap(buildAwsValue())
}
object DescribeReplayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeReplayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeReplayResponse =
      zio.aws.eventbridge.model.DescribeReplayResponse(
        replayName.map(value => value),
        replayArn.map(value => value),
        description.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        eventSourceArn.map(value => value),
        destination.map(value => value.asEditable),
        eventStartTime.map(value => value),
        eventEndTime.map(value => value),
        eventLastReplayedTime.map(value => value),
        replayStartTime.map(value => value),
        replayEndTime.map(value => value)
      )
    def replayName: Optional[ReplayName]
    def replayArn: Optional[ReplayArn]
    def description: Optional[ReplayDescription]
    def state: Optional[zio.aws.eventbridge.model.ReplayState]
    def stateReason: Optional[ReplayStateReason]
    def eventSourceArn: Optional[Arn]
    def destination
        : Optional[zio.aws.eventbridge.model.ReplayDestination.ReadOnly]
    def eventStartTime: Optional[Timestamp]
    def eventEndTime: Optional[Timestamp]
    def eventLastReplayedTime: Optional[Timestamp]
    def replayStartTime: Optional[Timestamp]
    def replayEndTime: Optional[Timestamp]
    def getReplayName: ZIO[Any, AwsError, ReplayName] =
      AwsError.unwrapOptionField("replayName", replayName)
    def getReplayArn: ZIO[Any, AwsError, ReplayArn] =
      AwsError.unwrapOptionField("replayArn", replayArn)
    def getDescription: ZIO[Any, AwsError, ReplayDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ReplayState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, ReplayStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ReplayDestination.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getEventStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventStartTime", eventStartTime)
    def getEventEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventEndTime", eventEndTime)
    def getEventLastReplayedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventLastReplayedTime", eventLastReplayedTime)
    def getReplayStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("replayStartTime", replayStartTime)
    def getReplayEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("replayEndTime", replayEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeReplayResponse
  ) extends zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly {
    override val replayName: Optional[ReplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.replayName())
      .map(value => zio.aws.eventbridge.model.primitives.ReplayName(value))
    override val replayArn: Optional[ReplayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.replayArn())
      .map(value => zio.aws.eventbridge.model.primitives.ReplayArn(value))
    override val description: Optional[ReplayDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ReplayDescription(value)
        )
    override val state: Optional[zio.aws.eventbridge.model.ReplayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ReplayState.wrap(value))
    override val stateReason: Optional[ReplayStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ReplayStateReason(value)
        )
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.eventbridge.model.primitives.Arn(value))
    override val destination
        : Optional[zio.aws.eventbridge.model.ReplayDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.eventbridge.model.ReplayDestination.wrap(value))
    override val eventStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventStartTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val eventEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventEndTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val eventLastReplayedTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventLastReplayedTime())
        .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val replayStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replayStartTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val replayEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replayEndTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeReplayResponse
  ): zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly = new Wrapper(
    impl
  )
}
