package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ReplayName
import scala.jdk.CollectionConverters._
final case class DescribeReplayRequest(replayName: ReplayName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest = {
    import DescribeReplayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest
      .builder()
      .replayName(ReplayName.unwrap(replayName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeReplayRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeReplayRequest.wrap(buildAwsValue())
}
object DescribeReplayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeReplayRequest =
      zio.aws.eventbridge.model.DescribeReplayRequest(replayName)
    def replayName: ReplayName
    def getReplayName: ZIO[Any, Nothing, ReplayName] = ZIO.succeed(replayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest
  ) extends zio.aws.eventbridge.model.DescribeReplayRequest.ReadOnly {
    override val replayName: ReplayName =
      zio.aws.eventbridge.model.primitives.ReplayName(impl.replayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest
  ): zio.aws.eventbridge.model.DescribeReplayRequest.ReadOnly = new Wrapper(
    impl
  )
}
