package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EventSourceName
import scala.jdk.CollectionConverters._
final case class DescribeEventSourceRequest(name: EventSourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest = {
    import DescribeEventSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest
      .builder()
      .name(EventSourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DescribeEventSourceRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeEventSourceRequest.wrap(buildAwsValue())
}
object DescribeEventSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeEventSourceRequest =
      zio.aws.eventbridge.model.DescribeEventSourceRequest(name)
    def name: EventSourceName
    def getName: ZIO[Any, Nothing, EventSourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest
  ) extends zio.aws.eventbridge.model.DescribeEventSourceRequest.ReadOnly {
    override val name: EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest
  ): zio.aws.eventbridge.model.DescribeEventSourceRequest.ReadOnly =
    new Wrapper(impl)
}
