package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.EventBusNameOrArn
import scala.jdk.CollectionConverters._
final case class DescribeEventBusRequest(
    name: Optional[EventBusNameOrArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest = {
    import DescribeEventBusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest
      .builder()
      .optionallyWith(
        name.map(value => EventBusNameOrArn.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeEventBusRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeEventBusRequest.wrap(buildAwsValue())
}
object DescribeEventBusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeEventBusRequest =
      zio.aws.eventbridge.model
        .DescribeEventBusRequest(name.map(value => value))
    def name: Optional[EventBusNameOrArn]
    def getName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest
  ) extends zio.aws.eventbridge.model.DescribeEventBusRequest.ReadOnly {
    override val name: Optional[EventBusNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest
  ): zio.aws.eventbridge.model.DescribeEventBusRequest.ReadOnly = new Wrapper(
    impl
  )
}
