package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{HomeRegion, EndpointName}
import scala.jdk.CollectionConverters._
final case class DescribeEndpointRequest(
    name: EndpointName,
    homeRegion: Optional[HomeRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest = {
    import DescribeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest
      .builder()
      .name(EndpointName.unwrap(name): java.lang.String)
      .optionallyWith(
        homeRegion.map(value => HomeRegion.unwrap(value): java.lang.String)
      )(_.homeRegion)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeEndpointRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeEndpointRequest.wrap(buildAwsValue())
}
object DescribeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeEndpointRequest =
      zio.aws.eventbridge.model
        .DescribeEndpointRequest(name, homeRegion.map(value => value))
    def name: EndpointName
    def homeRegion: Optional[HomeRegion]
    def getName: ZIO[Any, Nothing, EndpointName] = ZIO.succeed(name)
    def getHomeRegion: ZIO[Any, AwsError, HomeRegion] =
      AwsError.unwrapOptionField("homeRegion", homeRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest
  ) extends zio.aws.eventbridge.model.DescribeEndpointRequest.ReadOnly {
    override val name: EndpointName =
      zio.aws.eventbridge.model.primitives.EndpointName(impl.name())
    override val homeRegion: Optional[HomeRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.homeRegion())
      .map(value => zio.aws.eventbridge.model.primitives.HomeRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest
  ): zio.aws.eventbridge.model.DescribeEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
