package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  ConnectionDescription,
  Timestamp,
  ConnectionName,
  SecretsManagerSecretArn,
  ConnectionStateReason,
  ConnectionArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeConnectionResponse(
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    name: Optional[ConnectionName] = Optional.Absent,
    description: Optional[ConnectionDescription] = Optional.Absent,
    connectionState: Optional[zio.aws.eventbridge.model.ConnectionState] =
      Optional.Absent,
    stateReason: Optional[ConnectionStateReason] = Optional.Absent,
    authorizationType: Optional[
      zio.aws.eventbridge.model.ConnectionAuthorizationType
    ] = Optional.Absent,
    secretArn: Optional[SecretsManagerSecretArn] = Optional.Absent,
    authParameters: Optional[
      zio.aws.eventbridge.model.ConnectionAuthResponseParameters
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastAuthorizedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeConnectionResponse = {
    import DescribeConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeConnectionResponse
      .builder()
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        name.map(value => ConnectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ConnectionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(
        stateReason.map(value =>
          ConnectionStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(authorizationType.map(value => value.unwrap))(
        _.authorizationType
      )
      .optionallyWith(
        secretArn.map(value =>
          SecretsManagerSecretArn.unwrap(value): java.lang.String
        )
      )(_.secretArn)
      .optionallyWith(authParameters.map(value => value.buildAwsValue()))(
        _.authParameters
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        lastAuthorizedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastAuthorizedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeConnectionResponse.wrap(buildAwsValue())
}
object DescribeConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeConnectionResponse =
      zio.aws.eventbridge.model.DescribeConnectionResponse(
        connectionArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        connectionState.map(value => value),
        stateReason.map(value => value),
        authorizationType.map(value => value),
        secretArn.map(value => value),
        authParameters.map(value => value.asEditable),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastAuthorizedTime.map(value => value)
      )
    def connectionArn: Optional[ConnectionArn]
    def name: Optional[ConnectionName]
    def description: Optional[ConnectionDescription]
    def connectionState: Optional[zio.aws.eventbridge.model.ConnectionState]
    def stateReason: Optional[ConnectionStateReason]
    def authorizationType
        : Optional[zio.aws.eventbridge.model.ConnectionAuthorizationType]
    def secretArn: Optional[SecretsManagerSecretArn]
    def authParameters: Optional[
      zio.aws.eventbridge.model.ConnectionAuthResponseParameters.ReadOnly
    ]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def lastAuthorizedTime: Optional[Timestamp]
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ConnectionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.ConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getStateReason: ZIO[Any, AwsError, ConnectionStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getAuthorizationType: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionAuthorizationType
    ] = AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getSecretArn: ZIO[Any, AwsError, SecretsManagerSecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionAuthResponseParameters.ReadOnly
    ] = AwsError.unwrapOptionField("authParameters", authParameters)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastAuthorizedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastAuthorizedTime", lastAuthorizedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeConnectionResponse
  ) extends zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly {
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionArn(value))
    override val name: Optional[ConnectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionName(value))
    override val description: Optional[ConnectionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ConnectionDescription(value)
        )
    override val connectionState
        : Optional[zio.aws.eventbridge.model.ConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value => zio.aws.eventbridge.model.ConnectionState.wrap(value))
    override val stateReason: Optional[ConnectionStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ConnectionStateReason(value)
        )
    override val authorizationType
        : Optional[zio.aws.eventbridge.model.ConnectionAuthorizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationType())
        .map(value =>
          zio.aws.eventbridge.model.ConnectionAuthorizationType.wrap(value)
        )
    override val secretArn: Optional[SecretsManagerSecretArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretArn())
        .map(value =>
          zio.aws.eventbridge.model.primitives.SecretsManagerSecretArn(value)
        )
    override val authParameters: Optional[
      zio.aws.eventbridge.model.ConnectionAuthResponseParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authParameters())
      .map(value =>
        zio.aws.eventbridge.model.ConnectionAuthResponseParameters.wrap(value)
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastAuthorizedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAuthorizedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeConnectionResponse
  ): zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
