package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ConnectionName
import scala.jdk.CollectionConverters._
final case class DescribeConnectionRequest(name: ConnectionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest = {
    import DescribeConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest
      .builder()
      .name(ConnectionName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeConnectionRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeConnectionRequest.wrap(buildAwsValue())
}
object DescribeConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeConnectionRequest =
      zio.aws.eventbridge.model.DescribeConnectionRequest(name)
    def name: ConnectionName
    def getName: ZIO[Any, Nothing, ConnectionName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest
  ) extends zio.aws.eventbridge.model.DescribeConnectionRequest.ReadOnly {
    override val name: ConnectionName =
      zio.aws.eventbridge.model.primitives.ConnectionName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest
  ): zio.aws.eventbridge.model.DescribeConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
