package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ApiDestinationName
import scala.jdk.CollectionConverters._
final case class DescribeApiDestinationRequest(name: ApiDestinationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest = {
    import DescribeApiDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest
      .builder()
      .name(ApiDestinationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DescribeApiDestinationRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeApiDestinationRequest
      .wrap(buildAwsValue())
}
object DescribeApiDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeApiDestinationRequest =
      zio.aws.eventbridge.model.DescribeApiDestinationRequest(name)
    def name: ApiDestinationName
    def getName: ZIO[Any, Nothing, ApiDestinationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest
  ) extends zio.aws.eventbridge.model.DescribeApiDestinationRequest.ReadOnly {
    override val name: ApiDestinationName =
      zio.aws.eventbridge.model.primitives.ApiDestinationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest
  ): zio.aws.eventbridge.model.DescribeApiDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
