package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{AccountId, EventSourceName}
import scala.jdk.CollectionConverters._
final case class DeletePartnerEventSourceRequest(
    name: EventSourceName,
    account: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest = {
    import DeletePartnerEventSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest
      .builder()
      .name(EventSourceName.unwrap(name): java.lang.String)
      .account(AccountId.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DeletePartnerEventSourceRequest.ReadOnly =
    zio.aws.eventbridge.model.DeletePartnerEventSourceRequest
      .wrap(buildAwsValue())
}
object DeletePartnerEventSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeletePartnerEventSourceRequest =
      zio.aws.eventbridge.model.DeletePartnerEventSourceRequest(name, account)
    def name: EventSourceName
    def account: AccountId
    def getName: ZIO[Any, Nothing, EventSourceName] = ZIO.succeed(name)
    def getAccount: ZIO[Any, Nothing, AccountId] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest
  ) extends zio.aws.eventbridge.model.DeletePartnerEventSourceRequest.ReadOnly {
    override val name: EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName(impl.name())
    override val account: AccountId =
      zio.aws.eventbridge.model.primitives.AccountId(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest
  ): zio.aws.eventbridge.model.DeletePartnerEventSourceRequest.ReadOnly =
    new Wrapper(impl)
}
