package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EventBusName
import scala.jdk.CollectionConverters._
final case class DeleteEventBusRequest(name: EventBusName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest = {
    import DeleteEventBusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest
      .builder()
      .name(EventBusName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DeleteEventBusRequest.ReadOnly =
    zio.aws.eventbridge.model.DeleteEventBusRequest.wrap(buildAwsValue())
}
object DeleteEventBusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeleteEventBusRequest =
      zio.aws.eventbridge.model.DeleteEventBusRequest(name)
    def name: EventBusName
    def getName: ZIO[Any, Nothing, EventBusName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest
  ) extends zio.aws.eventbridge.model.DeleteEventBusRequest.ReadOnly {
    override val name: EventBusName =
      zio.aws.eventbridge.model.primitives.EventBusName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest
  ): zio.aws.eventbridge.model.DeleteEventBusRequest.ReadOnly = new Wrapper(
    impl
  )
}
