package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ConnectionName
import scala.jdk.CollectionConverters._
final case class DeauthorizeConnectionRequest(name: ConnectionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest = {
    import DeauthorizeConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest
      .builder()
      .name(ConnectionName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DeauthorizeConnectionRequest.ReadOnly =
    zio.aws.eventbridge.model.DeauthorizeConnectionRequest.wrap(buildAwsValue())
}
object DeauthorizeConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeauthorizeConnectionRequest =
      zio.aws.eventbridge.model.DeauthorizeConnectionRequest(name)
    def name: ConnectionName
    def getName: ZIO[Any, Nothing, ConnectionName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest
  ) extends zio.aws.eventbridge.model.DeauthorizeConnectionRequest.ReadOnly {
    override val name: ConnectionName =
      zio.aws.eventbridge.model.primitives.ConnectionName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest
  ): zio.aws.eventbridge.model.DeauthorizeConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
