package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{AccountId, EventSourceName}
import scala.jdk.CollectionConverters._
final case class CreatePartnerEventSourceRequest(
    name: EventSourceName,
    account: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest = {
    import CreatePartnerEventSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest
      .builder()
      .name(EventSourceName.unwrap(name): java.lang.String)
      .account(AccountId.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreatePartnerEventSourceRequest.ReadOnly =
    zio.aws.eventbridge.model.CreatePartnerEventSourceRequest
      .wrap(buildAwsValue())
}
object CreatePartnerEventSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreatePartnerEventSourceRequest =
      zio.aws.eventbridge.model.CreatePartnerEventSourceRequest(name, account)
    def name: EventSourceName
    def account: AccountId
    def getName: ZIO[Any, Nothing, EventSourceName] = ZIO.succeed(name)
    def getAccount: ZIO[Any, Nothing, AccountId] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest
  ) extends zio.aws.eventbridge.model.CreatePartnerEventSourceRequest.ReadOnly {
    override val name: EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName(impl.name())
    override val account: AccountId =
      zio.aws.eventbridge.model.primitives.AccountId(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest
  ): zio.aws.eventbridge.model.CreatePartnerEventSourceRequest.ReadOnly =
    new Wrapper(impl)
}
