package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEventBusResponse(
    eventBusArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse = {
    import CreateEventBusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
      .builder()
      .optionallyWith(eventBusArn.map(value => value: java.lang.String))(
        _.eventBusArn
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly =
    zio.aws.eventbridge.model.CreateEventBusResponse.wrap(buildAwsValue())
}
object CreateEventBusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateEventBusResponse =
      zio.aws.eventbridge.model
        .CreateEventBusResponse(eventBusArn.map(value => value))
    def eventBusArn: Optional[String]
    def getEventBusArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventBusArn", eventBusArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
  ) extends zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly {
    override val eventBusArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBusArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
  ): zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly = new Wrapper(
    impl
  )
}
