package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  ConnectionDescription,
  ConnectionName
}
import scala.jdk.CollectionConverters._
final case class CreateConnectionRequest(
    name: ConnectionName,
    description: Optional[ConnectionDescription] = Optional.Absent,
    authorizationType: zio.aws.eventbridge.model.ConnectionAuthorizationType,
    authParameters: zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest = {
    import CreateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest
      .builder()
      .name(ConnectionName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConnectionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .authorizationType(authorizationType.unwrap)
      .authParameters(authParameters.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateConnectionRequest.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionRequest.wrap(buildAwsValue())
}
object CreateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateConnectionRequest =
      zio.aws.eventbridge.model.CreateConnectionRequest(
        name,
        description.map(value => value),
        authorizationType,
        authParameters.asEditable
      )
    def name: ConnectionName
    def description: Optional[ConnectionDescription]
    def authorizationType: zio.aws.eventbridge.model.ConnectionAuthorizationType
    def authParameters
        : zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters.ReadOnly
    def getName: ZIO[Any, Nothing, ConnectionName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ConnectionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAuthorizationType: ZIO[
      Any,
      Nothing,
      zio.aws.eventbridge.model.ConnectionAuthorizationType
    ] = ZIO.succeed(authorizationType)
    def getAuthParameters: ZIO[
      Any,
      Nothing,
      zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters.ReadOnly
    ] = ZIO.succeed(authParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest
  ) extends zio.aws.eventbridge.model.CreateConnectionRequest.ReadOnly {
    override val name: ConnectionName =
      zio.aws.eventbridge.model.primitives.ConnectionName(impl.name())
    override val description: Optional[ConnectionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ConnectionDescription(value)
        )
    override val authorizationType
        : zio.aws.eventbridge.model.ConnectionAuthorizationType =
      zio.aws.eventbridge.model.ConnectionAuthorizationType
        .wrap(impl.authorizationType())
    override val authParameters
        : zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters.ReadOnly =
      zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters
        .wrap(impl.authParameters())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest
  ): zio.aws.eventbridge.model.CreateConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
