package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters._
final case class CreateConnectionOAuthClientRequestParameters(
    clientID: AuthHeaderParameters,
    clientSecret: AuthHeaderParameters
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters = {
    import CreateConnectionOAuthClientRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
      .builder()
      .clientID(AuthHeaderParameters.unwrap(clientID): java.lang.String)
      .clientSecret(AuthHeaderParameters.unwrap(clientSecret): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters
      .wrap(buildAwsValue())
}
object CreateConnectionOAuthClientRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters =
      zio.aws.eventbridge.model
        .CreateConnectionOAuthClientRequestParameters(clientID, clientSecret)
    def clientID: AuthHeaderParameters
    def clientSecret: AuthHeaderParameters
    def getClientID: ZIO[Any, Nothing, AuthHeaderParameters] =
      ZIO.succeed(clientID)
    def getClientSecret: ZIO[Any, Nothing, AuthHeaderParameters] =
      ZIO.succeed(clientSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
  ) extends zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly {
    override val clientID: AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives.AuthHeaderParameters(impl.clientID())
    override val clientSecret: AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives
        .AuthHeaderParameters(impl.clientSecret())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
  ): zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly =
    new Wrapper(impl)
}
