package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateConnectionAuthRequestParameters(
    basicAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters
    ] = Optional.Absent,
    oAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters
    ] = Optional.Absent,
    apiKeyAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
    ] = Optional.Absent,
    invocationHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionAuthRequestParameters = {
    import CreateConnectionAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionAuthRequestParameters
      .builder()
      .optionallyWith(basicAuthParameters.map(value => value.buildAwsValue()))(
        _.basicAuthParameters
      )
      .optionallyWith(oAuthParameters.map(value => value.buildAwsValue()))(
        _.oAuthParameters
      )
      .optionallyWith(apiKeyAuthParameters.map(value => value.buildAwsValue()))(
        _.apiKeyAuthParameters
      )
      .optionallyWith(
        invocationHttpParameters.map(value => value.buildAwsValue())
      )(_.invocationHttpParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters
      .wrap(buildAwsValue())
}
object CreateConnectionAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters =
      zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters(
        basicAuthParameters.map(value => value.asEditable),
        oAuthParameters.map(value => value.asEditable),
        apiKeyAuthParameters.map(value => value.asEditable),
        invocationHttpParameters.map(value => value.asEditable)
      )
    def basicAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters.ReadOnly
    ]
    def oAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters.ReadOnly
    ]
    def apiKeyAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters.ReadOnly
    ]
    def invocationHttpParameters
        : Optional[zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly]
    def getBasicAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("basicAuthParameters", basicAuthParameters)
    def getOAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthParameters", oAuthParameters)
    def getApiKeyAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("apiKeyAuthParameters", apiKeyAuthParameters)
    def getInvocationHttpParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "invocationHttpParameters",
      invocationHttpParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionAuthRequestParameters
  ) extends zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters.ReadOnly {
    override val basicAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.basicAuthParameters())
      .map(value =>
        zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters
          .wrap(value)
      )
    override val oAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthParameters())
      .map(value =>
        zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters
          .wrap(value)
      )
    override val apiKeyAuthParameters: Optional[
      zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKeyAuthParameters())
      .map(value =>
        zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
          .wrap(value)
      )
    override val invocationHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationHttpParameters())
      .map(value =>
        zio.aws.eventbridge.model.ConnectionHttpParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionAuthRequestParameters
  ): zio.aws.eventbridge.model.CreateConnectionAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
