package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  Timestamp,
  ArchiveStateReason,
  ArchiveArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateArchiveResponse(
    archiveArn: Optional[ArchiveArn] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ArchiveState] = Optional.Absent,
    stateReason: Optional[ArchiveStateReason] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateArchiveResponse = {
    import CreateArchiveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateArchiveResponse
      .builder()
      .optionallyWith(
        archiveArn.map(value => ArchiveArn.unwrap(value): java.lang.String)
      )(_.archiveArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          ArchiveStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly =
    zio.aws.eventbridge.model.CreateArchiveResponse.wrap(buildAwsValue())
}
object CreateArchiveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateArchiveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateArchiveResponse =
      zio.aws.eventbridge.model.CreateArchiveResponse(
        archiveArn.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        creationTime.map(value => value)
      )
    def archiveArn: Optional[ArchiveArn]
    def state: Optional[zio.aws.eventbridge.model.ArchiveState]
    def stateReason: Optional[ArchiveStateReason]
    def creationTime: Optional[Timestamp]
    def getArchiveArn: ZIO[Any, AwsError, ArchiveArn] =
      AwsError.unwrapOptionField("archiveArn", archiveArn)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ArchiveState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, ArchiveStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateArchiveResponse
  ) extends zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly {
    override val archiveArn: Optional[ArchiveArn] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveArn())
      .map(value => zio.aws.eventbridge.model.primitives.ArchiveArn(value))
    override val state: Optional[zio.aws.eventbridge.model.ArchiveState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ArchiveState.wrap(value))
    override val stateReason: Optional[ArchiveStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ArchiveStateReason(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateArchiveResponse
  ): zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly = new Wrapper(
    impl
  )
}
