package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  RetentionDays,
  ArchiveDescription,
  EventPattern,
  Arn,
  ArchiveName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateArchiveRequest(
    archiveName: ArchiveName,
    eventSourceArn: Arn,
    description: Optional[ArchiveDescription] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    retentionDays: Optional[RetentionDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest = {
    import CreateArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest
      .builder()
      .archiveName(ArchiveName.unwrap(archiveName): java.lang.String)
      .eventSourceArn(Arn.unwrap(eventSourceArn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ArchiveDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(
        retentionDays.map(value => RetentionDays.unwrap(value): Integer)
      )(_.retentionDays)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateArchiveRequest.ReadOnly =
    zio.aws.eventbridge.model.CreateArchiveRequest.wrap(buildAwsValue())
}
object CreateArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateArchiveRequest =
      zio.aws.eventbridge.model.CreateArchiveRequest(
        archiveName,
        eventSourceArn,
        description.map(value => value),
        eventPattern.map(value => value),
        retentionDays.map(value => value)
      )
    def archiveName: ArchiveName
    def eventSourceArn: Arn
    def description: Optional[ArchiveDescription]
    def eventPattern: Optional[EventPattern]
    def retentionDays: Optional[RetentionDays]
    def getArchiveName: ZIO[Any, Nothing, ArchiveName] =
      ZIO.succeed(archiveName)
    def getEventSourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(eventSourceArn)
    def getDescription: ZIO[Any, AwsError, ArchiveDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getRetentionDays: ZIO[Any, AwsError, RetentionDays] =
      AwsError.unwrapOptionField("retentionDays", retentionDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest
  ) extends zio.aws.eventbridge.model.CreateArchiveRequest.ReadOnly {
    override val archiveName: ArchiveName =
      zio.aws.eventbridge.model.primitives.ArchiveName(impl.archiveName())
    override val eventSourceArn: Arn =
      zio.aws.eventbridge.model.primitives.Arn(impl.eventSourceArn())
    override val description: Optional[ArchiveDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ArchiveDescription(value)
        )
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.eventbridge.model.primitives.EventPattern(value))
    override val retentionDays: Optional[RetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionDays())
      .map(value => zio.aws.eventbridge.model.primitives.RetentionDays(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest
  ): zio.aws.eventbridge.model.CreateArchiveRequest.ReadOnly = new Wrapper(impl)
}
