package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionOAuthHttpMethod {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod
}
object ConnectionOAuthHttpMethod {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod
  ): zio.aws.eventbridge.model.ConnectionOAuthHttpMethod = value match {
    case software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.GET =>
      val r = GET
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.POST =>
      val r = POST
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.PUT =>
      val r = PUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ConnectionOAuthHttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod =
      software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object GET extends zio.aws.eventbridge.model.ConnectionOAuthHttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod =
      software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.GET
  }
  case object POST extends zio.aws.eventbridge.model.ConnectionOAuthHttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod =
      software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.POST
  }
  case object PUT extends zio.aws.eventbridge.model.ConnectionOAuthHttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod =
      software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthHttpMethod.PUT
  }
}
