package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{HeaderValue, HeaderKey}
import scala.jdk.CollectionConverters._
final case class ConnectionHeaderParameter(
    key: Optional[HeaderKey] = Optional.Absent,
    value: Optional[HeaderValue] = Optional.Absent,
    isValueSecret: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionHeaderParameter = {
    import ConnectionHeaderParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionHeaderParameter
      .builder()
      .optionallyWith(
        key.map(value => HeaderKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => HeaderValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(isValueSecret.map(value => value: java.lang.Boolean))(
        _.isValueSecret
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ConnectionHeaderParameter.ReadOnly =
    zio.aws.eventbridge.model.ConnectionHeaderParameter.wrap(buildAwsValue())
}
object ConnectionHeaderParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionHeaderParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ConnectionHeaderParameter =
      zio.aws.eventbridge.model.ConnectionHeaderParameter(
        key.map(value => value),
        value.map(value => value),
        isValueSecret.map(value => value)
      )
    def key: Optional[HeaderKey]
    def value: Optional[HeaderValue]
    def isValueSecret: Optional[Boolean]
    def getKey: ZIO[Any, AwsError, HeaderKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, HeaderValue] =
      AwsError.unwrapOptionField("value", value)
    def getIsValueSecret: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isValueSecret", isValueSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionHeaderParameter
  ) extends zio.aws.eventbridge.model.ConnectionHeaderParameter.ReadOnly {
    override val key: Optional[HeaderKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.eventbridge.model.primitives.HeaderKey(value))
    override val value: Optional[HeaderValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.eventbridge.model.primitives.HeaderValue(value))
    override val isValueSecret: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isValueSecret())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionHeaderParameter
  ): zio.aws.eventbridge.model.ConnectionHeaderParameter.ReadOnly = new Wrapper(
    impl
  )
}
