package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters._
final case class ConnectionBasicAuthResponseParameters(
    username: Optional[AuthHeaderParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionBasicAuthResponseParameters = {
    import ConnectionBasicAuthResponseParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionBasicAuthResponseParameters
      .builder()
      .optionallyWith(
        username.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.username)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ConnectionBasicAuthResponseParameters.ReadOnly =
    zio.aws.eventbridge.model.ConnectionBasicAuthResponseParameters
      .wrap(buildAwsValue())
}
object ConnectionBasicAuthResponseParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionBasicAuthResponseParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.ConnectionBasicAuthResponseParameters =
      zio.aws.eventbridge.model
        .ConnectionBasicAuthResponseParameters(username.map(value => value))
    def username: Optional[AuthHeaderParameters]
    def getUsername: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionBasicAuthResponseParameters
  ) extends zio.aws.eventbridge.model.ConnectionBasicAuthResponseParameters.ReadOnly {
    override val username: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.username())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionBasicAuthResponseParameters
  ): zio.aws.eventbridge.model.ConnectionBasicAuthResponseParameters.ReadOnly =
    new Wrapper(impl)
}
