package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionAuthorizationType {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType
}
object ConnectionAuthorizationType {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType
  ): zio.aws.eventbridge.model.ConnectionAuthorizationType = value match {
    case software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.OAUTH_CLIENT_CREDENTIALS =>
      val r = OAUTH_CLIENT_CREDENTIALS
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.API_KEY =>
      val r = API_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ConnectionAuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType =
      software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC
      extends zio.aws.eventbridge.model.ConnectionAuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType =
      software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.BASIC
  }
  case object OAUTH_CLIENT_CREDENTIALS
      extends zio.aws.eventbridge.model.ConnectionAuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType =
      software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.OAUTH_CLIENT_CREDENTIALS
  }
  case object API_KEY
      extends zio.aws.eventbridge.model.ConnectionAuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType =
      software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType.API_KEY
  }
}
