package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters._
final case class ConnectionApiKeyAuthResponseParameters(
    apiKeyName: Optional[AuthHeaderParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionApiKeyAuthResponseParameters = {
    import ConnectionApiKeyAuthResponseParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionApiKeyAuthResponseParameters
      .builder()
      .optionallyWith(
        apiKeyName.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.apiKeyName)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ConnectionApiKeyAuthResponseParameters.ReadOnly =
    zio.aws.eventbridge.model.ConnectionApiKeyAuthResponseParameters
      .wrap(buildAwsValue())
}
object ConnectionApiKeyAuthResponseParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionApiKeyAuthResponseParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.ConnectionApiKeyAuthResponseParameters =
      zio.aws.eventbridge.model
        .ConnectionApiKeyAuthResponseParameters(apiKeyName.map(value => value))
    def apiKeyName: Optional[AuthHeaderParameters]
    def getApiKeyName: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("apiKeyName", apiKeyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionApiKeyAuthResponseParameters
  ) extends zio.aws.eventbridge.model.ConnectionApiKeyAuthResponseParameters.ReadOnly {
    override val apiKeyName: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeyName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionApiKeyAuthResponseParameters
  ): zio.aws.eventbridge.model.ConnectionApiKeyAuthResponseParameters.ReadOnly =
    new Wrapper(impl)
}
