package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchParameters(
    jobDefinition: String,
    jobName: String,
    arrayProperties: Optional[zio.aws.eventbridge.model.BatchArrayProperties] =
      Optional.Absent,
    retryStrategy: Optional[zio.aws.eventbridge.model.BatchRetryStrategy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.BatchParameters = {
    import BatchParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.BatchParameters
      .builder()
      .jobDefinition(jobDefinition: java.lang.String)
      .jobName(jobName: java.lang.String)
      .optionallyWith(arrayProperties.map(value => value.buildAwsValue()))(
        _.arrayProperties
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.BatchParameters.ReadOnly =
    zio.aws.eventbridge.model.BatchParameters.wrap(buildAwsValue())
}
object BatchParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.BatchParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.BatchParameters =
      zio.aws.eventbridge.model.BatchParameters(
        jobDefinition,
        jobName,
        arrayProperties.map(value => value.asEditable),
        retryStrategy.map(value => value.asEditable)
      )
    def jobDefinition: String
    def jobName: String
    def arrayProperties
        : Optional[zio.aws.eventbridge.model.BatchArrayProperties.ReadOnly]
    def retryStrategy
        : Optional[zio.aws.eventbridge.model.BatchRetryStrategy.ReadOnly]
    def getJobDefinition: ZIO[Any, Nothing, String] = ZIO.succeed(jobDefinition)
    def getJobName: ZIO[Any, Nothing, String] = ZIO.succeed(jobName)
    def getArrayProperties: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.BatchArrayProperties.ReadOnly
    ] = AwsError.unwrapOptionField("arrayProperties", arrayProperties)
    def getRetryStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.BatchRetryStrategy.ReadOnly
    ] = AwsError.unwrapOptionField("retryStrategy", retryStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.BatchParameters
  ) extends zio.aws.eventbridge.model.BatchParameters.ReadOnly {
    override val jobDefinition: String = impl.jobDefinition(): String
    override val jobName: String = impl.jobName(): String
    override val arrayProperties
        : Optional[zio.aws.eventbridge.model.BatchArrayProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arrayProperties())
        .map(value =>
          zio.aws.eventbridge.model.BatchArrayProperties.wrap(value)
        )
    override val retryStrategy
        : Optional[zio.aws.eventbridge.model.BatchRetryStrategy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryStrategy())
        .map(value => zio.aws.eventbridge.model.BatchRetryStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.BatchParameters
  ): zio.aws.eventbridge.model.BatchParameters.ReadOnly = new Wrapper(impl)
}
