package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class BatchArrayProperties(
    size: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.BatchArrayProperties = {
    import BatchArrayProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.BatchArrayProperties
      .builder()
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.BatchArrayProperties.ReadOnly =
    zio.aws.eventbridge.model.BatchArrayProperties.wrap(buildAwsValue())
}
object BatchArrayProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.BatchArrayProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.BatchArrayProperties =
      zio.aws.eventbridge.model.BatchArrayProperties(size.map(value => value))
    def size: Optional[Integer]
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.BatchArrayProperties
  ) extends zio.aws.eventbridge.model.BatchArrayProperties.ReadOnly {
    override val size: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.BatchArrayProperties
  ): zio.aws.eventbridge.model.BatchArrayProperties.ReadOnly = new Wrapper(impl)
}
