package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters._
sealed trait ApiDestinationState {
  def unwrap
      : software.amazon.awssdk.services.eventbridge.model.ApiDestinationState
}
object ApiDestinationState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ApiDestinationState
  ): zio.aws.eventbridge.model.ApiDestinationState = value match {
    case software.amazon.awssdk.services.eventbridge.model.ApiDestinationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ApiDestinationState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.eventbridge.model.ApiDestinationState.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ApiDestinationState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ApiDestinationState =
      software.amazon.awssdk.services.eventbridge.model.ApiDestinationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.eventbridge.model.ApiDestinationState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ApiDestinationState =
      software.amazon.awssdk.services.eventbridge.model.ApiDestinationState.ACTIVE
  }
  case object INACTIVE extends zio.aws.eventbridge.model.ApiDestinationState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ApiDestinationState =
      software.amazon.awssdk.services.eventbridge.model.ApiDestinationState.INACTIVE
  }
}
