package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EventSourceName
import scala.jdk.CollectionConverters._
final case class ActivateEventSourceRequest(name: EventSourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest = {
    import ActivateEventSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest
      .builder()
      .name(EventSourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ActivateEventSourceRequest.ReadOnly =
    zio.aws.eventbridge.model.ActivateEventSourceRequest.wrap(buildAwsValue())
}
object ActivateEventSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ActivateEventSourceRequest =
      zio.aws.eventbridge.model.ActivateEventSourceRequest(name)
    def name: EventSourceName
    def getName: ZIO[Any, Nothing, EventSourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest
  ) extends zio.aws.eventbridge.model.ActivateEventSourceRequest.ReadOnly {
    override val name: EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest
  ): zio.aws.eventbridge.model.ActivateEventSourceRequest.ReadOnly =
    new Wrapper(impl)
}
