package zio.aws.eventbridge
import zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClient
import zio.aws.eventbridge.model.primitives.RuleName
import zio.aws.core.AwsError
import zio.aws.eventbridge.model.{
  DescribeReplayRequest,
  CreateEndpointRequest,
  TestEventPatternRequest,
  DeleteEventBusRequest,
  PutTargetsRequest,
  DeleteEndpointRequest,
  EnableRuleRequest,
  DeactivateEventSourceRequest,
  RemoveTargetsRequest,
  ListTargetsByRuleRequest,
  CreateConnectionRequest,
  DescribePartnerEventSourceRequest,
  ListEndpointsRequest,
  ListPartnerEventSourceAccountsRequest,
  ListRulesRequest,
  CreatePartnerEventSourceRequest,
  ListArchivesRequest,
  PutPermissionRequest,
  DescribeRuleRequest,
  CreateArchiveRequest,
  UpdateEndpointRequest,
  ListTagsForResourceRequest,
  DeauthorizeConnectionRequest,
  DeleteApiDestinationRequest,
  CreateEventBusRequest,
  PutRuleRequest,
  ListEventBusesRequest,
  DeletePartnerEventSourceRequest,
  DeleteConnectionRequest,
  DescribeEventSourceRequest,
  DeleteArchiveRequest,
  ListEventSourcesRequest,
  PutPartnerEventsRequest,
  UpdateArchiveRequest,
  ActivateEventSourceRequest,
  DeleteRuleRequest,
  DescribeArchiveRequest,
  CreateApiDestinationRequest,
  ListReplaysRequest,
  UpdateConnectionRequest,
  DescribeEventBusRequest,
  UpdateApiDestinationRequest,
  UntagResourceRequest,
  PutEventsRequest,
  DescribeEndpointRequest,
  ListConnectionsRequest,
  ListRuleNamesByTargetRequest,
  DescribeApiDestinationRequest,
  RemovePermissionRequest,
  CancelReplayRequest,
  ListPartnerEventSourcesRequest,
  DescribeConnectionRequest,
  TagResourceRequest,
  StartReplayRequest,
  DisableRuleRequest,
  ListApiDestinationsRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object EventBridgeMock extends Mock[EventBridge] {
  object CancelReplay
      extends Effect[
        CancelReplayRequest,
        AwsError,
        zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly
      ]
  object CreateArchive
      extends Effect[
        CreateArchiveRequest,
        AwsError,
        zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly
      ]
  object PutPermission extends Effect[PutPermissionRequest, AwsError, Unit]
  object DeleteEventBus extends Effect[DeleteEventBusRequest, AwsError, Unit]
  object ActivateEventSource
      extends Effect[ActivateEventSourceRequest, AwsError, Unit]
  object ListArchives
      extends Stream[
        ListArchivesRequest,
        AwsError,
        zio.aws.eventbridge.model.Archive.ReadOnly
      ]
  object ListArchivesPaginated
      extends Effect[
        ListArchivesRequest,
        AwsError,
        zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly
      ]
  object CreatePartnerEventSource
      extends Effect[
        CreatePartnerEventSourceRequest,
        AwsError,
        zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly
      ]
  object CreateConnection
      extends Effect[
        CreateConnectionRequest,
        AwsError,
        zio.aws.eventbridge.model.CreateConnectionResponse.ReadOnly
      ]
  object DeleteApiDestination
      extends Effect[
        DeleteApiDestinationRequest,
        AwsError,
        zio.aws.eventbridge.model.DeleteApiDestinationResponse.ReadOnly
      ]
  object DescribeConnection
      extends Effect[
        DescribeConnectionRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly
      ]
  object TestEventPattern
      extends Effect[
        TestEventPatternRequest,
        AwsError,
        zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly
      ]
  object UpdateConnection
      extends Effect[
        UpdateConnectionRequest,
        AwsError,
        zio.aws.eventbridge.model.UpdateConnectionResponse.ReadOnly
      ]
  object PutTargets
      extends Effect[
        PutTargetsRequest,
        AwsError,
        zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly
      ]
  object CreateEventBus
      extends Effect[CreateEventBusRequest, AwsError, ReadOnly]
  object DisableRule extends Effect[DisableRuleRequest, AwsError, Unit]
  object ListPartnerEventSources
      extends Stream[
        ListPartnerEventSourcesRequest,
        AwsError,
        zio.aws.eventbridge.model.PartnerEventSource.ReadOnly
      ]
  object ListPartnerEventSourcesPaginated
      extends Effect[
        ListPartnerEventSourcesRequest,
        AwsError,
        zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly
      ]
  object PutEvents
      extends Effect[
        PutEventsRequest,
        AwsError,
        zio.aws.eventbridge.model.PutEventsResponse.ReadOnly
      ]
  object DeleteRule extends Effect[DeleteRuleRequest, AwsError, Unit]
  object DeleteArchive
      extends Effect[
        DeleteArchiveRequest,
        AwsError,
        zio.aws.eventbridge.model.DeleteArchiveResponse.ReadOnly
      ]
  object DeleteEndpoint
      extends Effect[
        DeleteEndpointRequest,
        AwsError,
        zio.aws.eventbridge.model.DeleteEndpointResponse.ReadOnly
      ]
  object ListConnections
      extends Stream[
        ListConnectionsRequest,
        AwsError,
        zio.aws.eventbridge.model.Connection.ReadOnly
      ]
  object ListConnectionsPaginated
      extends Effect[
        ListConnectionsRequest,
        AwsError,
        zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly
      ]
  object DescribePartnerEventSource
      extends Effect[
        DescribePartnerEventSourceRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly
      ]
  object ListEventBuses
      extends Stream[
        ListEventBusesRequest,
        AwsError,
        zio.aws.eventbridge.model.EventBus.ReadOnly
      ]
  object ListEventBusesPaginated
      extends Effect[
        ListEventBusesRequest,
        AwsError,
        zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly
      ]
  object UpdateArchive
      extends Effect[
        UpdateArchiveRequest,
        AwsError,
        zio.aws.eventbridge.model.UpdateArchiveResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.eventbridge.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeEndpoint
      extends Effect[
        DescribeEndpointRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly
      ]
  object PutRule
      extends Effect[
        PutRuleRequest,
        AwsError,
        zio.aws.eventbridge.model.PutRuleResponse.ReadOnly
      ]
  object DescribeRule
      extends Effect[
        DescribeRuleRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly
      ]
  object ListEventSources
      extends Stream[
        ListEventSourcesRequest,
        AwsError,
        zio.aws.eventbridge.model.EventSource.ReadOnly
      ]
  object ListEventSourcesPaginated
      extends Effect[
        ListEventSourcesRequest,
        AwsError,
        zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly
      ]
  object ListApiDestinations
      extends Stream[
        ListApiDestinationsRequest,
        AwsError,
        zio.aws.eventbridge.model.ApiDestination.ReadOnly
      ]
  object ListApiDestinationsPaginated
      extends Effect[
        ListApiDestinationsRequest,
        AwsError,
        zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly
      ]
  object RemovePermission
      extends Effect[RemovePermissionRequest, AwsError, Unit]
  object DeletePartnerEventSource
      extends Effect[DeletePartnerEventSourceRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.eventbridge.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeApiDestination
      extends Effect[
        DescribeApiDestinationRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.eventbridge.model.DeleteConnectionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.eventbridge.model.TagResourceResponse.ReadOnly
      ]
  object CreateEndpoint
      extends Effect[
        CreateEndpointRequest,
        AwsError,
        zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly
      ]
  object ListRules
      extends Stream[
        ListRulesRequest,
        AwsError,
        zio.aws.eventbridge.model.Rule.ReadOnly
      ]
  object ListRulesPaginated
      extends Effect[
        ListRulesRequest,
        AwsError,
        zio.aws.eventbridge.model.ListRulesResponse.ReadOnly
      ]
  object UpdateEndpoint
      extends Effect[
        UpdateEndpointRequest,
        AwsError,
        zio.aws.eventbridge.model.UpdateEndpointResponse.ReadOnly
      ]
  object ListEndpoints
      extends Stream[
        ListEndpointsRequest,
        AwsError,
        zio.aws.eventbridge.model.Endpoint.ReadOnly
      ]
  object ListEndpointsPaginated
      extends Effect[
        ListEndpointsRequest,
        AwsError,
        zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly
      ]
  object CreateApiDestination
      extends Effect[
        CreateApiDestinationRequest,
        AwsError,
        zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly
      ]
  object DeauthorizeConnection
      extends Effect[
        DeauthorizeConnectionRequest,
        AwsError,
        zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly
      ]
  object UpdateApiDestination
      extends Effect[
        UpdateApiDestinationRequest,
        AwsError,
        zio.aws.eventbridge.model.UpdateApiDestinationResponse.ReadOnly
      ]
  object DescribeReplay
      extends Effect[
        DescribeReplayRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly
      ]
  object ListRuleNamesByTarget
      extends Stream[ListRuleNamesByTargetRequest, AwsError, RuleName]
  object ListRuleNamesByTargetPaginated
      extends Effect[
        ListRuleNamesByTargetRequest,
        AwsError,
        zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly
      ]
  object ListReplays
      extends Stream[
        ListReplaysRequest,
        AwsError,
        zio.aws.eventbridge.model.Replay.ReadOnly
      ]
  object ListReplaysPaginated
      extends Effect[
        ListReplaysRequest,
        AwsError,
        zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly
      ]
  object EnableRule extends Effect[EnableRuleRequest, AwsError, Unit]
  object DescribeEventBus
      extends Effect[
        DescribeEventBusRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly
      ]
  object StartReplay
      extends Effect[
        StartReplayRequest,
        AwsError,
        zio.aws.eventbridge.model.StartReplayResponse.ReadOnly
      ]
  object DescribeEventSource
      extends Effect[
        DescribeEventSourceRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeEventSourceResponse.ReadOnly
      ]
  object PutPartnerEvents
      extends Effect[
        PutPartnerEventsRequest,
        AwsError,
        zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly
      ]
  object RemoveTargets
      extends Effect[
        RemoveTargetsRequest,
        AwsError,
        zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly
      ]
  object DeactivateEventSource
      extends Effect[DeactivateEventSourceRequest, AwsError, Unit]
  object ListPartnerEventSourceAccounts
      extends Stream[
        ListPartnerEventSourceAccountsRequest,
        AwsError,
        zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly
      ]
  object ListPartnerEventSourceAccountsPaginated
      extends Effect[
        ListPartnerEventSourceAccountsRequest,
        AwsError,
        zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly
      ]
  object DescribeArchive
      extends Effect[
        DescribeArchiveRequest,
        AwsError,
        zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly
      ]
  object ListTargetsByRule
      extends Stream[
        ListTargetsByRuleRequest,
        AwsError,
        zio.aws.eventbridge.model.Target.ReadOnly
      ]
  object ListTargetsByRulePaginated
      extends Effect[
        ListTargetsByRuleRequest,
        AwsError,
        zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, EventBridge] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, EventBridge] { rts =>
        zio.ZIO.succeed {
          new EventBridge {
            val api: EventBridgeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): EventBridge = this
            def cancelReplay(request: CancelReplayRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly
            ] = proxy(CancelReplay, request)
            def createArchive(request: CreateArchiveRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly
            ] = proxy(CreateArchive, request)
            def putPermission(
                request: PutPermissionRequest
            ): IO[AwsError, Unit] = proxy(PutPermission, request)
            def deleteEventBus(
                request: DeleteEventBusRequest
            ): IO[AwsError, Unit] = proxy(DeleteEventBus, request)
            def activateEventSource(
                request: ActivateEventSourceRequest
            ): IO[AwsError, Unit] = proxy(ActivateEventSource, request)
            def listArchives(request: ListArchivesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.Archive.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListArchives, request)
                }
                .getOrThrowFiberFailure()
            }
            def listArchivesPaginated(request: ListArchivesRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly
            ] = proxy(ListArchivesPaginated, request)
            def createPartnerEventSource(
                request: CreatePartnerEventSourceRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly
            ] = proxy(CreatePartnerEventSource, request)
            def createConnection(request: CreateConnectionRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.CreateConnectionResponse.ReadOnly
            ] = proxy(CreateConnection, request)
            def deleteApiDestination(request: DeleteApiDestinationRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DeleteApiDestinationResponse.ReadOnly
            ] = proxy(DeleteApiDestination, request)
            def describeConnection(request: DescribeConnectionRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly
            ] = proxy(DescribeConnection, request)
            def testEventPattern(request: TestEventPatternRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly
            ] = proxy(TestEventPattern, request)
            def updateConnection(request: UpdateConnectionRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.UpdateConnectionResponse.ReadOnly
            ] = proxy(UpdateConnection, request)
            def putTargets(request: PutTargetsRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly
            ] = proxy(PutTargets, request)
            def createEventBus(
                request: CreateEventBusRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateEventBus, request)
            def disableRule(request: DisableRuleRequest): IO[AwsError, Unit] =
              proxy(DisableRule, request)
            def listPartnerEventSources(
                request: ListPartnerEventSourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.PartnerEventSource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPartnerEventSources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPartnerEventSourcesPaginated(
                request: ListPartnerEventSourcesRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly
            ] = proxy(ListPartnerEventSourcesPaginated, request)
            def putEvents(request: PutEventsRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.PutEventsResponse.ReadOnly
            ] = proxy(PutEvents, request)
            def deleteRule(request: DeleteRuleRequest): IO[AwsError, Unit] =
              proxy(DeleteRule, request)
            def deleteArchive(request: DeleteArchiveRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DeleteArchiveResponse.ReadOnly
            ] = proxy(DeleteArchive, request)
            def deleteEndpoint(request: DeleteEndpointRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DeleteEndpointResponse.ReadOnly
            ] = proxy(DeleteEndpoint, request)
            def listConnections(request: ListConnectionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.Connection.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConnections, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConnectionsPaginated(request: ListConnectionsRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly
            ] = proxy(ListConnectionsPaginated, request)
            def describePartnerEventSource(
                request: DescribePartnerEventSourceRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly
            ] = proxy(DescribePartnerEventSource, request)
            def listEventBuses(request: ListEventBusesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.EventBus.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventBuses, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventBusesPaginated(request: ListEventBusesRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly
            ] = proxy(ListEventBusesPaginated, request)
            def updateArchive(request: UpdateArchiveRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.UpdateArchiveResponse.ReadOnly
            ] = proxy(UpdateArchive, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeEndpoint(request: DescribeEndpointRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly
            ] = proxy(DescribeEndpoint, request)
            def putRule(request: PutRuleRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.PutRuleResponse.ReadOnly
            ] = proxy(PutRule, request)
            def describeRule(request: DescribeRuleRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly
            ] = proxy(DescribeRule, request)
            def listEventSources(request: ListEventSourcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.EventSource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventSources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventSourcesPaginated(request: ListEventSourcesRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly
            ] = proxy(ListEventSourcesPaginated, request)
            def listApiDestinations(
                request: ListApiDestinationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.ApiDestination.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApiDestinations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApiDestinationsPaginated(
                request: ListApiDestinationsRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly
            ] = proxy(ListApiDestinationsPaginated, request)
            def removePermission(
                request: RemovePermissionRequest
            ): IO[AwsError, Unit] = proxy(RemovePermission, request)
            def deletePartnerEventSource(
                request: DeletePartnerEventSourceRequest
            ): IO[AwsError, Unit] = proxy(DeletePartnerEventSource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def describeApiDestination(
                request: DescribeApiDestinationRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly
            ] = proxy(DescribeApiDestination, request)
            def deleteConnection(request: DeleteConnectionRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DeleteConnectionResponse.ReadOnly
            ] = proxy(DeleteConnection, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createEndpoint(request: CreateEndpointRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly
            ] = proxy(CreateEndpoint, request)
            def listRules(
                request: ListRulesRequest
            ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Rule.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListRules, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listRulesPaginated(request: ListRulesRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListRulesResponse.ReadOnly
            ] = proxy(ListRulesPaginated, request)
            def updateEndpoint(request: UpdateEndpointRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.UpdateEndpointResponse.ReadOnly
            ] = proxy(UpdateEndpoint, request)
            def listEndpoints(request: ListEndpointsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.Endpoint.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEndpoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEndpointsPaginated(request: ListEndpointsRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly
            ] = proxy(ListEndpointsPaginated, request)
            def createApiDestination(request: CreateApiDestinationRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly
            ] = proxy(CreateApiDestination, request)
            def deauthorizeConnection(
                request: DeauthorizeConnectionRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly
            ] = proxy(DeauthorizeConnection, request)
            def updateApiDestination(request: UpdateApiDestinationRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.UpdateApiDestinationResponse.ReadOnly
            ] = proxy(UpdateApiDestination, request)
            def describeReplay(request: DescribeReplayRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly
            ] = proxy(DescribeReplay, request)
            def listRuleNamesByTarget(
                request: ListRuleNamesByTargetRequest
            ): ZStream[Any, AwsError, RuleName] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListRuleNamesByTarget, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listRuleNamesByTargetPaginated(
                request: ListRuleNamesByTargetRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly
            ] = proxy(ListRuleNamesByTargetPaginated, request)
            def listReplays(request: ListReplaysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.Replay.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReplays, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReplaysPaginated(request: ListReplaysRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly
            ] = proxy(ListReplaysPaginated, request)
            def enableRule(request: EnableRuleRequest): IO[AwsError, Unit] =
              proxy(EnableRule, request)
            def describeEventBus(request: DescribeEventBusRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly
            ] = proxy(DescribeEventBus, request)
            def startReplay(request: StartReplayRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.StartReplayResponse.ReadOnly
            ] = proxy(StartReplay, request)
            def describeEventSource(request: DescribeEventSourceRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeEventSourceResponse.ReadOnly
            ] = proxy(DescribeEventSource, request)
            def putPartnerEvents(request: PutPartnerEventsRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly
            ] = proxy(PutPartnerEvents, request)
            def removeTargets(request: RemoveTargetsRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly
            ] = proxy(RemoveTargets, request)
            def deactivateEventSource(
                request: DeactivateEventSourceRequest
            ): IO[AwsError, Unit] = proxy(DeactivateEventSource, request)
            def listPartnerEventSourceAccounts(
                request: ListPartnerEventSourceAccountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPartnerEventSourceAccounts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPartnerEventSourceAccountsPaginated(
                request: ListPartnerEventSourceAccountsRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly
            ] = proxy(ListPartnerEventSourceAccountsPaginated, request)
            def describeArchive(request: DescribeArchiveRequest): IO[
              AwsError,
              zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly
            ] = proxy(DescribeArchive, request)
            def listTargetsByRule(request: ListTargetsByRuleRequest): ZStream[
              Any,
              AwsError,
              zio.aws.eventbridge.model.Target.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTargetsByRule, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTargetsByRulePaginated(
                request: ListTargetsByRuleRequest
            ): IO[
              AwsError,
              zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly
            ] = proxy(ListTargetsByRulePaginated, request)
          }
        }
      }
    }
  }
}
