package zio.aws.entityresolution
import zio.aws.entityresolution.model.primitives.{
  AttributeName,
  TagValue,
  RecordAttributeMapKeyString,
  RecordAttributeMapValueString,
  AwsAccountId,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.entityresolution.model.primitives.AttributeName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.entityresolution.model.primitives.AttributeName.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId =
      zio.aws.entityresolution.model.primitives.AwsAccountId.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.entityresolution.model.primitives.Description.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.entityresolution.model.primitives.EntityName.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage =
      zio.aws.entityresolution.model.primitives.ErrorMessage.Type
    object IdMappingWorkflowArn extends Subtype[String]
    type IdMappingWorkflowArn =
      zio.aws.entityresolution.model.primitives.IdMappingWorkflowArn.Type
    object IdMappingWorkflowInputSourceInputSourceARNString
        extends Subtype[String]
    type IdMappingWorkflowInputSourceInputSourceARNString =
      zio.aws.entityresolution.model.primitives.IdMappingWorkflowInputSourceInputSourceARNString.Type
    object InputSourceInputSourceARNString extends Subtype[String]
    type InputSourceInputSourceARNString =
      zio.aws.entityresolution.model.primitives.InputSourceInputSourceARNString.Type
    type Integer = Int
    object JobId extends Subtype[String]
    type JobId = zio.aws.entityresolution.model.primitives.JobId.Type
    object KMSArn extends Subtype[String]
    type KMSArn = zio.aws.entityresolution.model.primitives.KMSArn.Type
    object ListIdMappingJobsInputMaxResultsInteger extends Subtype[Int]
    type ListIdMappingJobsInputMaxResultsInteger =
      zio.aws.entityresolution.model.primitives.ListIdMappingJobsInputMaxResultsInteger.Type
    object ListIdMappingWorkflowsInputMaxResultsInteger extends Subtype[Int]
    type ListIdMappingWorkflowsInputMaxResultsInteger =
      zio.aws.entityresolution.model.primitives.ListIdMappingWorkflowsInputMaxResultsInteger.Type
    object ListMatchingJobsInputMaxResultsInteger extends Subtype[Int]
    type ListMatchingJobsInputMaxResultsInteger =
      zio.aws.entityresolution.model.primitives.ListMatchingJobsInputMaxResultsInteger.Type
    object ListMatchingWorkflowsInputMaxResultsInteger extends Subtype[Int]
    type ListMatchingWorkflowsInputMaxResultsInteger =
      zio.aws.entityresolution.model.primitives.ListMatchingWorkflowsInputMaxResultsInteger.Type
    object ListProviderServicesInputMaxResultsInteger extends Subtype[Int]
    type ListProviderServicesInputMaxResultsInteger =
      zio.aws.entityresolution.model.primitives.ListProviderServicesInputMaxResultsInteger.Type
    object ListSchemaMappingsInputMaxResultsInteger extends Subtype[Int]
    type ListSchemaMappingsInputMaxResultsInteger =
      zio.aws.entityresolution.model.primitives.ListSchemaMappingsInputMaxResultsInteger.Type
    object MatchingWorkflowArn extends Subtype[String]
    type MatchingWorkflowArn =
      zio.aws.entityresolution.model.primitives.MatchingWorkflowArn.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.entityresolution.model.primitives.NextToken.Type
    object ProviderServiceArn extends Subtype[String]
    type ProviderServiceArn =
      zio.aws.entityresolution.model.primitives.ProviderServiceArn.Type
    object ProviderServiceDisplayName extends Subtype[String]
    type ProviderServiceDisplayName =
      zio.aws.entityresolution.model.primitives.ProviderServiceDisplayName.Type
    object RecordAttributeMapKeyString extends Subtype[String]
    type RecordAttributeMapKeyString =
      zio.aws.entityresolution.model.primitives.RecordAttributeMapKeyString.Type
    object RecordAttributeMapValueString extends Subtype[String]
    type RecordAttributeMapValueString =
      zio.aws.entityresolution.model.primitives.RecordAttributeMapValueString.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.entityresolution.model.primitives.RoleArn.Type
    object RuleRuleNameString extends Subtype[String]
    type RuleRuleNameString =
      zio.aws.entityresolution.model.primitives.RuleRuleNameString.Type
    object S3Path extends Subtype[String]
    type S3Path = zio.aws.entityresolution.model.primitives.S3Path.Type
    object SchemaMappingArn extends Subtype[String]
    type SchemaMappingArn =
      zio.aws.entityresolution.model.primitives.SchemaMappingArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.entityresolution.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.entityresolution.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.entityresolution.model.primitives.Timestamp.Type
    object VeniceGlobalArn extends Subtype[String]
    type VeniceGlobalArn =
      zio.aws.entityresolution.model.primitives.VeniceGlobalArn.Type
  }
  type AwsAccountIdList = List[AwsAccountId]
  type Document = software.amazon.awssdk.core.document.Document
  type IdMappingWorkflowInputSourceConfig =
    List[zio.aws.entityresolution.model.IdMappingWorkflowInputSource]
  type IdMappingWorkflowList =
    List[zio.aws.entityresolution.model.IdMappingWorkflowSummary]
  type IdMappingWorkflowOutputSourceConfig =
    List[zio.aws.entityresolution.model.IdMappingWorkflowOutputSource]
  type InputSourceConfig = List[zio.aws.entityresolution.model.InputSource]
  type JobList = List[zio.aws.entityresolution.model.JobSummary]
  type MatchingWorkflowList =
    List[zio.aws.entityresolution.model.MatchingWorkflowSummary]
  type OutputSourceConfig = List[zio.aws.entityresolution.model.OutputSource]
  type OutputSourceOutputList =
    List[zio.aws.entityresolution.model.OutputAttribute]
  type ProviderServiceList =
    List[zio.aws.entityresolution.model.ProviderServiceSummary]
  type RecordAttributeMap =
    Map[RecordAttributeMapKeyString, RecordAttributeMapValueString]
  type RequiredBucketActionsList = List[String]
  type RuleBasedPropertiesRulesList = List[zio.aws.entityresolution.model.Rule]
  type RuleMatchingKeysList = List[AttributeName]
  type SchemaInputAttributes =
    List[zio.aws.entityresolution.model.SchemaInputAttribute]
  type SchemaMappingList =
    List[zio.aws.entityresolution.model.SchemaMappingSummary]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
